package com.yd.question.feign.fallback;

import com.yd.common.result.Result;
import com.yd.question.feign.client.ApiQuestionnairesFeignClient;
import com.yd.question.feign.request.ApiAnswerSaveRequest;
import com.yd.question.feign.response.ApiAnswerSaveResponse;
import com.yd.question.feign.response.ApiQuestionnairesDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 问题基础服务-问卷信息Feign降级处理
 */
@Slf4j
@Component
public class ApiQuestionnairesFeignFallbackFactory implements FallbackFactory<ApiQuestionnairesFeignClient> {
    @Override
    public ApiQuestionnairesFeignClient create(Throwable cause) {
        return new ApiQuestionnairesFeignClient() {
            @Override
            public Result<ApiQuestionnairesDetailResponse> detail(String questionnaireBizId, String objectBizId) {
                return null;
            }

            @Override
            public Result<ApiAnswerSaveResponse> answerSave(ApiAnswerSaveRequest request) {
                return null;
            }
        };
    }
}
