package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.model.AddQuestions;
import com.yd.question.service.dao.AddQuestionsMapper;
import com.yd.question.service.model.Options;
import com.yd.question.service.service.IAddQuestionsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 选项附加问题表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Service
public class AddQuestionsServiceImpl extends ServiceImpl<AddQuestionsMapper, AddQuestions> implements IAddQuestionsService {

    /**
     * 查询列表
     * @param addQuestionsBizIdList
     * @return
     */
    @Override
    public List<AddQuestions> queryList(List<String> addQuestionsBizIdList) {
        List<AddQuestions> list = baseMapper.selectList(new LambdaQueryWrapper<AddQuestions>()
                .in(!CollectionUtils.isEmpty(addQuestionsBizIdList),AddQuestions::getAddQuestionsBizId,addQuestionsBizIdList)
        );
        return list;
    }
}
