package com.yd.question.feign.response;

import com.yd.question.feign.dto.ApiFirstCategoryDto;
import com.yd.question.feign.dto.ApiQuestionnairesDto;
import com.yd.question.feign.dto.ApiFirstAndSecondCategoryDto;
import com.yd.question.feign.dto.ApiQuestionsDto;
import lombok.Data;
import java.util.List;

/**
 * 问卷详细信息出参
 */
@Data
public class ApiQuestionnairesDetailResponse {

    /**
     * 问卷基础信息DTO
     */
    private ApiQuestionnairesDto questionnairesDto;

    /**
     * 一二级分类分组的问题列表信息
     */
    private List<ApiFirstAndSecondCategoryDto> firstAndSecondCategoryDtoList;

    /**
     * 一级分类分组的问题列表信息
     */
    private List<ApiFirstCategoryDto> firstCategoryDtoList;

    /**
     * 分类平铺，问题列表信息（分类平铺层级结构问题列表）
     */
    private List<ApiQuestionsDto> questionsDtoList;

    /**
     * 选择哪个List做为展示，1-firstAndSecondCategoryDtoList（一二级分类分组的问题列表信息） 2-firstCategoryDtoList（一级分类分组的问题列表信息） 3-questionsDtoList（分类平铺，问题列表信息（分类平铺层级结构问题列表））
     */
    private Integer selectListFlag;
}
