package com.yd.question.feign.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiObjectSaveRequest {

    /**
     * 答题的对象业务ID（操作的业务对象，例：预约信息业务唯一ID）
     */
    @NotBlank(message = "答题的对象业务ID不能为空")
    private String objectBizId;

    /**
     * 对象名
     */
    private String objectName;

    /**
     * 对象表名
     */
    private String objectTableName;

    /**
     * 答题选择的问卷唯一业务ID
     */
    @NotBlank(message = "答题选择的问卷唯一业务ID不能为空")
    private String questionnaireBizId;

}
