package com.yd.question.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.question.service.model.RelQuestionnaireQuestions;
import com.yd.question.service.dao.RelQuestionnaireQuestionsMapper;
import com.yd.question.service.service.IRelQuestionnaireQuestionsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.SysProject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 问卷问题关联表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-12
 */
@Service
public class RelQuestionnaireQuestionsServiceImpl extends ServiceImpl<RelQuestionnaireQuestionsMapper, RelQuestionnaireQuestions> implements IRelQuestionnaireQuestionsService {

    /**
     * 查询列表
     * @param questionnaireBizId
     * @return
     */
    @Override
    public List<RelQuestionnaireQuestions> queryList(String questionnaireBizId) {
        List<RelQuestionnaireQuestions> list = baseMapper.selectList(new LambdaQueryWrapper<RelQuestionnaireQuestions>()
                .eq(StringUtils.isNotBlank(questionnaireBizId),RelQuestionnaireQuestions::getQuestionnaireBizId,questionnaireBizId)
        );
        return list;
    }

}
