package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiExpectedCommissionRatioService;
import com.yd.product.feign.client.expectedcommissionratio.ApiExpectedCommissionRatioFeignClient;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioAddRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioEditRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioDetailResponse;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 来佣比率规格明细信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/expectedCommissionRatio")
@Validated
public class ApiExpectedCommissionRatioController implements ApiExpectedCommissionRatioFeignClient {

    @Autowired
    private ApiExpectedCommissionRatioService apiExpectedCommissionRatioService;


    /**
     * 分页列表查询-来佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedCommissionRatioPageResponse>> page(ApiExpectedCommissionRatioPageRequest request) {
        return apiExpectedCommissionRatioService.page(request);
    }

    /**
     * 批量保存-来佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result batchSave(ApiExpectedCommissionRatioBatchSaveRequest request) {
        return apiExpectedCommissionRatioService.batchSave(request);
    }

    /**
     * 添加-来佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiExpectedCommissionRatioAddRequest request) {
        return apiExpectedCommissionRatioService.add(request);
    }

    /**
     * 编辑-来佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiExpectedCommissionRatioEditRequest request) {
        return apiExpectedCommissionRatioService.edit(request);
    }

    /**
     * 编辑-状态
     * @param expectedCommissionRatioBizId
     * @param status
     * @return
     */
    @Override
    public Result editStatus(String expectedCommissionRatioBizId, Integer status) {
        return apiExpectedCommissionRatioService.editStatus(expectedCommissionRatioBizId,status);
    }

    /**
     * 详情-来佣比率规格明细信息
     * @param expectedSpeciesBizId 来佣比率规格明细表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiExpectedCommissionRatioDetailResponse> detail(String expectedSpeciesBizId) {
        return apiExpectedCommissionRatioService.detail(expectedSpeciesBizId);
    }

    /**
     * 删除-来佣比率规格明细信息
     * @param expectedCommissionRatioBizId 来佣比率规格明细表唯一业务ID
     * @return
     */
    @Override
    public Result del(String expectedCommissionRatioBizId) {
        return apiExpectedCommissionRatioService.del(expectedCommissionRatioBizId);
    }

    /**
     * 复制-来佣比率规格明细信息
     * @param expectedSpeciesBizId 来佣比率规格明细表唯一业务ID
     * @return
     */
    @Override
    public Result copy(String expectedSpeciesBizId) {
        return apiExpectedCommissionRatioService.copy(expectedSpeciesBizId);
    }
}
