package com.yd.product.service.utils;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;

public class MyBatisPlusCodeGenerator {
    public static void main(String[] args) {
        FastAutoGenerator.create("jdbc:mysql://localhost:3306/yd_product?serverTimezone=GMT%2B8", "root", "123456")
                .globalConfig(builder -> {
                    builder.author("zxm")
//                            .outputDir("src/main/java/com/yd/user/service");
                            .outputDir("D:/soft/ideaproject/v2/yd-product/yd-product-service/src/main/java");
                })
                .packageConfig(builder -> {
                    builder.parent("com.yd.product.service")
                            .entity("model")
                            .mapper("dao")
                            .service("service")
                            .serviceImpl("service.impl")
                            .xml("mappers");
                })
                .strategyConfig(builder -> {
                    builder.addInclude(
                            "field","field_value","rel_object_field",
                            "file","category","rel_object_category",
                            "species","rel_object_species","product",
                            "expected_commission_ratio","rel_product_announcement",
                            "product_launch","attribute_setting","species_setting",
                            "species_price","rel_tenant_product_launch","rel_project_product_launch",
                            "additional_product","rel_additional_product","rel_product_dept","rel_additional_product_dept",
                            "rel_tenant_product","rel_project_product"
                    )
                            .entityBuilder()
                            .enableLombok()
                            .enableTableFieldAnnotation()
                            .controllerBuilder()
                            .enableRestStyle();
                })
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}

