package com.yd.product.feign.client.expectedspecies;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.expectedspecies.ApiExpectedSpeciesFeignFallbackFactory;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesImportRequest;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesListRequest;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesPageRequest;
import com.yd.product.feign.response.expectedspecies.ApiExpectedSpeciesListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 产品服务-来佣比率规格信息Feign客户端
 */
@FeignClient(name = "yd-product-api",path = "/product/api/expectedSpecies",fallbackFactory = ApiExpectedSpeciesFeignFallbackFactory.class)
public interface ApiExpectedSpeciesFeignClient {

    /**
     * 分页列表查询-来佣比率规格信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiExpectedSpeciesPageRequest request);

    /**
     * 导入规格数据
     * @param request
     * @return
     */
    @PostMapping("/import/species")
    Result importSpecies(@RequestBody ApiExpectedSpeciesImportRequest request);

    /**
     * 删除规格数据
     * @param expectedSpeciesBizId
     * @return
     */
    @DeleteMapping("/del/species")
    Result delSpecies(@NotBlank(message = "来佣比率规格表唯一业务ID不能为空") @RequestParam(value = "expectedSpeciesBizId") String expectedSpeciesBizId);

    /**
     * 列表查询-来佣比率规格和规格明细信息
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiExpectedSpeciesListResponse>> list(@RequestBody ApiExpectedSpeciesListRequest request);
}
