package com.yd.product.feign.client.announcementspecies;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.announcementspecies.ApiAnnouncementSpeciesFeignFallbackFactory;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesImportRequest;
import com.yd.product.feign.request.announcementspecies.ApiAnnouncementSpeciesPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * 产品服务-公告佣比率规格信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiAnnouncementSpeciesFeignFallbackFactory.class)
public interface ApiAnnouncementSpeciesFeignClient {

    /**
     * 分页列表查询-公告佣比率规格信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiAnnouncementSpeciesPageRequest request);

    /**
     * 导入规格数据
     * @param request
     * @return
     */
    @PostMapping("/import/species")
    Result importSpecies(@RequestBody ApiAnnouncementSpeciesImportRequest request);

    /**
     * 删除规格数据
     * @param announcementSpeciesBizId
     * @return
     */
    @DeleteMapping("/del/species")
    Result delSpecies(@NotBlank(message = "公告佣比率规格表唯一业务ID不能为空") @RequestParam(value = "announcementSpeciesBizId") String announcementSpeciesBizId);
}
