package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 上架产品属性（参数）配置表（新表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("attribute_setting")
public class AttributeSetting implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品属性（参数）配置表唯一业务ID
     */
    @TableField("attribute_setting_biz_id")
    private String attributeSettingBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 字段表唯一业务ID
     */
    @TableField("field_biz_id")
    private String fieldBizId;

    /**
     * 字段值表唯一业务ID
     */
    @TableField("field_value_biz_id")
    private String fieldValueBizId;

    /**
     * 字段名称
     */
    @TableField("name")
    private String name;

    /**
     * 字段值
     */
    @TableField("value")
    private String value;

    /**
     * 是否自定义 0-否 1-是
     */
    @TableField("is_customize")
    private String isCustomize;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
