package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiProductService;
import com.yd.product.feign.client.product.ApiProductFeignClient;
import com.yd.product.feign.request.product.ApiProductAddRequest;
import com.yd.product.feign.request.product.ApiProductEditRequest;
import com.yd.product.feign.request.product.ApiProductPageRequest;
import com.yd.product.feign.response.product.ApiProductDetailResponse;
import com.yd.product.feign.response.product.ApiProductPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品基础信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/product")
@Validated
public class ApiProductController implements ApiProductFeignClient {

    @Autowired
    private ApiProductService apiProductService;

    /**
     * 分页列表查询-产品基础信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiProductPageResponse>> page(ApiProductPageRequest request) {
        return apiProductService.page(request);
    }
//
//    /**
//     * 编辑-产品基础信息
//     * @param request
//     * @return
//     */
//    @Override
//    public Result edit(ApiProductEditRequest request) {
//        return apiProductService.edit(request);
//    }
//
//    /**
//     * 详情-产品基础信息
//     * @param productBizId 产品基础信息表唯一业务ID
//     * @return
//     */
//    @Override
//    public Result<ApiProductDetailResponse> detail(String productBizId) {
//        return apiProductService.detail(productBizId);
//    }
//
//    /**
//     * 删除-产品基础信息 TODO
//     * @param productBizId 产品基础信息表唯一业务ID
//     * @return
//     */
//    @Override
//    public Result del(String productBizId) {
//        return apiProductService.del(productBizId);
//    }
}
