package com.yd.product.feign.request.expectedcommissionratio;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiExpectedCommissionRatioEditRequest {

    /**
     * 来佣比率规格明细表唯一业务ID
     */
    @NotBlank(message = "来佣比率规格明细表唯一业务ID不能为空")
    private String expectedCommissionRatioBizId;

    /**
     * 来佣比率规格表唯一业务ID
     */
    @NotBlank(message = "来佣比率规格表唯一业务ID不能为空")
    private String expectedSpeciesBizId;

    /**
     * 费用名称（转介费等）
     */
    @NotBlank(message = "费用名称（转介费等）不能为空")
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    @NotBlank(message = "佣金年限（起）不能为空")
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    @NotBlank(message = "佣金年限（止）不能为空")
    private String endPeriod;

    /**
     * 标保折算比例（基本保费）
     */
    @NotNull(message = "标保折算比例（基本保费）不能为空")
    private BigDecimal discountRatio;

    /**
     * 佣金率
     */
    @NotNull(message = "佣金率不能为空")
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    @NotNull(message = "有效开始时间不能为空")
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    @NotNull(message = "有效结束时间不能为空")
    private LocalDateTime effectiveEnd;

    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    @NotBlank(message = "是否受汇率影响不能为空")
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    @NotBlank(message = "结算币种不能为空")
    private String currency;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 销售组织
     */
    private String salesOrg;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 是否直签 (0-否 1-是，字典)
     */
    private String isDirectSign;
}
