package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.product.service.dto.SpeciesPriceDto;
import com.yd.product.service.model.SpeciesPrice;
import com.yd.product.service.dao.SpeciesPriceMapper;
import com.yd.product.service.service.ISpeciesPriceService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * <p>
 * 上架产品规格价格维护表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class SpeciesPriceServiceImpl extends ServiceImpl<SpeciesPriceMapper, SpeciesPrice> implements ISpeciesPriceService {

    @Override
    public List<SpeciesPrice> queryList(SpeciesPriceDto dto) {
        List<SpeciesPrice> list = baseMapper.selectList(new LambdaQueryWrapper<SpeciesPrice>()
                .eq(StringUtils.isNotBlank(dto.getProductLaunchBizId()),SpeciesPrice::getProductLaunchBizId,dto.getProductLaunchBizId())
        );
        return list;
    }
}
