package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiProductLaunchService;
import com.yd.product.feign.client.productlaunch.ApiProductLaunchFeignClient;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchCategoryAddRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchPageRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchSaveRequest;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchCategoryAddResponse;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchDetailResponse;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品上架信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/productLaunch")
@Validated
public class ApiProductLaunchController implements ApiProductLaunchFeignClient {

    @Autowired
    private ApiProductLaunchService apiProductLaunchService;

    /**
     * 分页列表查询-产品上架信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiProductLaunchPageResponse>> page(ApiProductLaunchPageRequest request) {
        return apiProductLaunchService.page(request);
    }

    /**
     * 添加-产品上架类目信息
     * @param request
     * @return
     */
    @Override
    public Result<ApiProductLaunchCategoryAddResponse> addCategory(ApiProductLaunchCategoryAddRequest request) {
        return apiProductLaunchService.addCategory(request);
    }

    /**
     * 详情-产品上架信息
     * @param productLaunchBizId 产品上架信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiProductLaunchDetailResponse> detail(String productLaunchBizId) {
        return apiProductLaunchService.detail(productLaunchBizId);
    }

    /**
     * 保存-产品上架信息
     * @param request
     * @return
     */
    @Override
    public Result save(ApiProductLaunchSaveRequest request) {
        return apiProductLaunchService.save(request);
    }


}
