package com.yd.product.feign.fallback.productlaunch;

import com.yd.common.result.Result;
import com.yd.product.feign.client.productlaunch.ApiProductLaunchFeignClient;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchCategoryAddRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchPageRequest;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchSaveRequest;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchCategoryAddResponse;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-产品上架信息Feign降级处理
 */
@Slf4j
@Component
public class ApiProductLaunchFeignFallbackFactory implements FallbackFactory<ApiProductLaunchFeignClient> {
    @Override
    public ApiProductLaunchFeignClient create(Throwable cause) {
        return new ApiProductLaunchFeignClient() {
            @Override
            public Result page(ApiProductLaunchPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiProductLaunchCategoryAddResponse> addCategory(ApiProductLaunchCategoryAddRequest request) {
                return null;
            }

            @Override
            public Result<ApiProductLaunchDetailResponse> detail(String productLaunchBizId) {
                return null;
            }

            @Override
            public Result save(ApiProductLaunchSaveRequest request) {
                return null;
            }
        };
    }
}
