package com.yd.product.feign.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
public class ApiProductLaunchDto {

    /**
     * 产品上架信息表唯一业务ID
     */
    @NotBlank(message = "产品上架信息表唯一业务ID不能为空")
    private String productLaunchBizId;

    /**
     * 关联产品表唯一业务ID（上架的产品）
     */
    @NotBlank(message = "关联产品表唯一业务ID不能为空")
    private String productBizId;

    /**
     * 标题
     */
    private String title;

    /**
     * 短标题
     */
    private String shortTitle;

    /**
     * 主图url列表
     */
    private List<String> mainUrlsList;

    /**
     * 详情图列表
     */
    private List<String> detailUrlsList;

    /**
     * 详情描述
     */
    private String detailDescription;

    /**
     * 状态：0-待审核 1-审核成功 2-审核失败 3-在售 4-停售 5-下架 6-预售
     */
    private Integer status;
}
