package com.yd.product.feign.client.product;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.product.ApiProductFeignFallbackFactory;
import com.yd.product.feign.request.product.ApiProductEditRequest;
import com.yd.product.feign.request.product.ApiProductPageRequest;
import com.yd.product.feign.response.product.ApiProductDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 产品服务-产品基础信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiProductFeignFallbackFactory.class)
public interface ApiProductFeignClient {

    /**
     * 分页列表查询-产品基础信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiProductPageRequest request);

//    /**
//     * 编辑-产品基础信息
//     * @param request
//     * @return
//     */
//    @PutMapping("/edit")
//    Result edit(@Validated @RequestBody ApiProductEditRequest request);
//
//    /**
//     * 详情-产品基础信息
//     * @param productBizId 产品基础信息表唯一业务ID
//     * @return
//     */
//    @GetMapping("/detail")
//    Result<ApiProductDetailResponse> detail(@NotBlank(message = "产品基础信息表唯一业务ID能为空") @RequestParam(value = "productBizId") String productBizId);
//
//    /**
//     * 删除-产品基础信息
//     * @param productBizId 产品基础信息表唯一业务ID
//     * @return
//     */
//    @DeleteMapping("/del")
//    Result del(@NotBlank(message = "产品基础信息表唯一业务ID能为空") @RequestParam(value = "productBizId") String productBizId);
}
