package com.yd.product.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiExpectedCommissionRatioService;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioPageResponse;
import com.yd.product.service.service.IExpectedCommissionRatioService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class ApiExpectedCommissionRatioServiceImpl implements ApiExpectedCommissionRatioService {

    @Autowired
    private IExpectedCommissionRatioService iExpectedCommissionRatioService;

    /**
     * 分页列表查询-预计来佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedCommissionRatioPageResponse>> page(ApiExpectedCommissionRatioPageRequest request) {
        Page<ApiExpectedCommissionRatioPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiExpectedCommissionRatioPageResponse> iPage = iExpectedCommissionRatioService.page(page, request);
        return Result.success(iPage);
    }

}
