package com.yd.product.api.service.impl;

import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.product.api.service.ApiAttributeSettingService;
import com.yd.product.feign.response.productlaunch.ApiAttributeSettingDto;
import com.yd.product.service.dto.AttributeSettingDto;
import com.yd.product.service.model.AttributeSetting;
import com.yd.product.service.service.IAttributeSettingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiAttributeSettingServiceImpl implements ApiAttributeSettingService {

    @Autowired
    private IAttributeSettingService iAttributeSettingService;

    /**
     * 保存产品属性（参数）配置信息
     * @param apiAttributeSettingDtoList
     * @param productLaunchBizId
     * @return
     */
    @Override
    public Result save(List<ApiAttributeSettingDto> apiAttributeSettingDtoList, String productLaunchBizId) {
        //先删后新增
        iAttributeSettingService.delByProductLaunchBizId(productLaunchBizId);

        //新增
        if (!CollectionUtils.isEmpty(apiAttributeSettingDtoList)) {
            List<AttributeSetting> attributeSettingList = apiAttributeSettingDtoList.stream().map(dto -> {
                AttributeSetting attributeSetting = new AttributeSetting();
                BeanUtils.copyProperties(dto,attributeSetting);
                attributeSetting.setProductLaunchBizId(productLaunchBizId);
                attributeSetting.setAttributeSettingBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_ATTRIBUTE_SETTING.getCode()));
                return attributeSetting;
            }).collect(Collectors.toList());
            iAttributeSettingService.saveOrUpdateBatch(attributeSettingList);
        }
        return Result.success();
    }

    /**
     * 根据产品上架信息id查询产品属性（参数）配置列表
     * @param productLaunchBizId
     * @return
     */
    @Override
    public List<ApiAttributeSettingDto> queryAttributeSettingDtoList(String productLaunchBizId) {
        List<ApiAttributeSettingDto> apiAttributeSettingDtoList = new ArrayList<>();
        List<AttributeSetting> attributeSettingList = iAttributeSettingService.queryList(AttributeSettingDto.builder()
                .productLaunchBizId(productLaunchBizId)
                .build());
        if (!CollectionUtils.isEmpty(attributeSettingList)) {
            apiAttributeSettingDtoList = attributeSettingList.stream().map(dto -> {
                ApiAttributeSettingDto settingDto = new ApiAttributeSettingDto();
                BeanUtils.copyProperties(dto,settingDto);
                return settingDto;
            }).collect(Collectors.toList());
        }
        return apiAttributeSettingDtoList;
    }
}
