package com.yd.product.feign.request.productlaunch;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiProductLaunchCategoryAddRequest {

    /**
     * 产品唯一业务ID（搜索的产品，有数据选择带入产品唯一业务ID和产品名称，不选择->自定义产品名称不带入产品唯一业务ID）
     */
    private String productBizId;

    /**
     * 产品名称
     */
    @NotBlank(message = "产品名称不能为空")
    private String productName;

    /**
     * 主图和视频url列表
     */
    @NotEmpty(message = "主图和视频url列表不能为空")
    private List<String> mainUrlsList;

    /**
     * 分类表唯一业务ID列表
     */
    @NotEmpty(message = "分类表唯一业务ID列表不能为空")
    private List<String> categoryBizIdList;

}
