package com.yd.product.feign.response.announcementspecies;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiAnnouncementSpeciesDetailPageResponse {

    //======公告佣比率规格表信息start======
    /**
     * 公告佣比率规格表唯一业务ID
     */
    private String announcementSpeciesBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID
     */
    private String productBizId;

    /**
     * 保障计划（0-64岁等）(固定规格条件)
     */
    private String protectionPlan;

    /**
     * 供款年期（5、10、20年期等）(固定规格条件)
     */
    private String paymentTerm;

    //======公告佣比率规格表信息end======


    //======公告佣比率规格明细表信息start======
    /**
     * 公告佣比率规格明细表唯一业务ID
     */
    private String announcementCommissionRatioBizId;

    /**
     * 费用名称（转介费等）
     */
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    private String endPeriod;

    /**
     * 标保折算比例（基本保费）
     */
    private BigDecimal discountRatio;

    /**
     * 计算基数（保费/保费*折算比例）
     */
    private BigDecimal cardinalNumber;

    /**
     * 佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    private LocalDateTime effectiveEnd;

    /**
     * 适用范围（经纪人/分销员/加盟商/签单员/转介人/全部，字典）
     */
    private String scope;

    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    private String currency;
    //======公告佣比率规格明细表信息end======
}
