package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.product.feign.request.relprojectproductlaunch.ApiRelProjectProductLaunchPageRequest;
import com.yd.product.feign.response.relprojectproductlaunch.ApiRelProjectProductLaunchPageResponse;
import com.yd.product.service.model.RelProjectProductLaunch;
import com.yd.product.service.dao.RelProjectProductLaunchMapper;
import com.yd.product.service.service.IRelProjectProductLaunchService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 项目-产品上架信息关系表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class RelProjectProductLaunchServiceImpl extends ServiceImpl<RelProjectProductLaunchMapper, RelProjectProductLaunch> implements IRelProjectProductLaunchService {

    @Override
    public IPage<ApiRelProjectProductLaunchPageResponse> page(Page<ApiRelProjectProductLaunchPageResponse> page,
                                                              ApiRelProjectProductLaunchPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public Boolean delByProductLaunchBizId(String productLaunchBizId) {
        return this.remove(new LambdaQueryWrapper<RelProjectProductLaunch>().eq(RelProjectProductLaunch::getProductLaunchBizId,productLaunchBizId));
    }
}
