package com.yd.product.feign.response.relprojectproductlaunch;

import com.yd.product.feign.dto.ApiSpeciesPriceDto;
import com.yd.product.feign.dto.ApiSpeciesTypeDto;
import com.yd.product.feign.response.productlaunch.ApiAttributeSettingDto;
import lombok.Data;
import java.util.List;

@Data
public class ApiRelProjectProductLaunchPageResponse {

    /**
     * 租户唯一业务ID
     */
    private String tenantBizId;

    /**
     * 项目唯一业务ID
     */
    private String projectBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 关联产品表唯一业务ID（上架的产品）
     */
    private String productBizId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 标题
     */
    private String title;

    /**
     * 短标题
     */
    private String shortTitle;

    /**
     * 主图url（多个url用分号分隔）
     */
    private String mainUrls;

    /**
     * 详情图（多个url用分号分隔）
     */
    private String detailUrls;

    /**
     * 详情描述
     */
    private String detailDescription;

    /**
     * 上架状态
     */
    private String status;

    /**
     * 审核备注
     */
    private String approvalRemark;

    /**
     * 设置的产品参数列表
     */
    private List<ApiAttributeSettingDto> apiAttributeSettingDtoList;

    /**
     * 规格信息配置列表
     */
    private List<ApiSpeciesTypeDto> apiSpeciesTypeDtoList;

    /**
     * 规格价格配置列表
     */
    private List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList;
}
