package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiAnnouncementCommissionRatioService;
import com.yd.product.feign.client.announcementcommissionratio.ApiAnnouncementCommissionRatioFeignClient;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioEditRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioAddRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioDetailResponse;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 公告佣比率规格明细信息
 *
 * @author zxm
 * @since 2025-11-27
 */
@RestController
@RequestMapping("/announcementCommissionRatio")
@Validated
public class ApiAnnouncementCommissionRatioController implements ApiAnnouncementCommissionRatioFeignClient {

    @Autowired
    private ApiAnnouncementCommissionRatioService apiAnnouncementCommissionRatioService;

    /**
     * 分页列表查询-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAnnouncementCommissionRatioPageResponse>> page(ApiAnnouncementCommissionRatioPageRequest request) {
        return apiAnnouncementCommissionRatioService.page(request);
    }

    /**
     * 批量保存-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result batchSave(ApiAnnouncementCommissionRatioBatchSaveRequest request) {
        return apiAnnouncementCommissionRatioService.batchSave(request);
    }

    /**
     * 添加-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiAnnouncementCommissionRatioAddRequest request) {
        return apiAnnouncementCommissionRatioService.add(request);
    }

    /**
     * 编辑-公告佣比率规格明细信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiAnnouncementCommissionRatioEditRequest request) {
        return apiAnnouncementCommissionRatioService.edit(request);
    }

    /**
     * 编辑-状态
     * @param announcementCommissionRatioBizId
     * @param status
     * @return
     */
    @Override
    public Result editStatus(String announcementCommissionRatioBizId,Integer status) {
        return apiAnnouncementCommissionRatioService.editStatus(announcementCommissionRatioBizId,status);
    }

    /**
     * 详情-公告佣比率规格明细信息
     * @param announcementCommissionRatioBizId 公告佣比率规格明细表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiAnnouncementCommissionRatioDetailResponse> detail(String announcementCommissionRatioBizId) {
        return apiAnnouncementCommissionRatioService.detail(announcementCommissionRatioBizId);
    }

    /**
     * 删除-公告佣比率规格明细信息
     * @param announcementCommissionRatioBizId 公告佣比率规格明细表唯一业务ID
     * @return
     */
    @Override
    public Result del(String announcementCommissionRatioBizId) {
        return apiAnnouncementCommissionRatioService.del(announcementCommissionRatioBizId);
    }

    /**
     * 复制-公告佣比率规格明细信息
     * @param announcementCommissionRatioBizId 公告佣比率规格明细表唯一业务ID
     * @return
     */
    @Override
    public Result copy(String announcementCommissionRatioBizId) {
        return apiAnnouncementCommissionRatioService.copy(announcementCommissionRatioBizId);
    }
}
