package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.product.service.dto.SpeciesSettingDto;
import com.yd.product.service.model.SpeciesSetting;
import com.yd.product.service.dao.SpeciesSettingMapper;
import com.yd.product.service.service.ISpeciesSettingService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 上架产品规格配置表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class SpeciesSettingServiceImpl extends ServiceImpl<SpeciesSettingMapper, SpeciesSetting> implements ISpeciesSettingService {

    @Override
    public List<SpeciesSetting> queryList(SpeciesSettingDto dto) {
        List<SpeciesSetting> list = baseMapper.selectList(new LambdaQueryWrapper<SpeciesSetting>()
                .eq(StringUtils.isNotBlank(dto.getProductLaunchBizId()),SpeciesSetting::getProductLaunchBizId,dto.getProductLaunchBizId())
        );
        return list;
    }

    @Override
    public Boolean delByProductLaunchBizId(String productLaunchBizId) {
        return this.remove(new LambdaQueryWrapper<SpeciesSetting>().eq(SpeciesSetting::getProductLaunchBizId,productLaunchBizId));
    }
}
