package com.yd.product.feign.response.announcementcommissionratio;

import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class ApiAnnouncementCommissionRatioPageResponse {

    /**
     * 公告佣比率表主键ID
     */
    private Long id;

    /**
     * 公告佣比率表唯一业务ID
     */
    private String announcementCommissionRatioBizId;

    /**
     * 产品上架信息表唯一业务ID（冗余）
     */
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID（冗余）
     */
    private String productBizId;

    /**
     * 规格条件列表JSON串
     */
    private String speciesJson;

    /**
     * 供款年期（产品有5年期的有10年期等）
     */
    private String term;

    /**
     * 期数（数字代表第几年）
     */
    private String issueNumber;

    /**
     * 公告比例
     */
    private BigDecimal announcementRatio;

    /**
     * 有效开始时间
     */
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间（不在这个时间区间内，公告比例按照announcement_ratio算，在这个区间内公告比例按照有效期内公告比例算）
     */
    private LocalDateTime effectiveEnd;

    /**
     * 有效期内公告比例
     */
    private BigDecimal ratio;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
