package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiAnnouncementCommissionRatioService;
import com.yd.product.feign.client.announcementcommissionratio.ApiAnnouncementCommissionRatioFeignClient;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioSaveRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioDetailResponse;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公告佣比率信息
 *
 * @author zxm
 * @since 2025-11-27
 */
@RestController
@RequestMapping("/announcementCommissionRatio")
@Validated
public class ApiAnnouncementCommissionRatioController implements ApiAnnouncementCommissionRatioFeignClient {

    @Autowired
    private ApiAnnouncementCommissionRatioService apiAnnouncementCommissionRatioService;

    /**
     * 分页列表查询-公告佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiAnnouncementCommissionRatioPageResponse>> page(ApiAnnouncementCommissionRatioPageRequest request) {
        return apiAnnouncementCommissionRatioService.page(request);
    }

    /**
     * 保存-公告佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result save(ApiAnnouncementCommissionRatioSaveRequest request) {
        return apiAnnouncementCommissionRatioService.save(request);
    }

    /**
     * 详情-公告佣比率信息
     * @param announcementCommissionRatioBizId 公告佣比率表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiAnnouncementCommissionRatioDetailResponse> detail(String announcementCommissionRatioBizId) {
        return apiAnnouncementCommissionRatioService.detail(announcementCommissionRatioBizId);
    }
}
