package com.yd.product.feign.request.productattribute;

import com.yd.product.feign.dto.ApiRelObjectFieldDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiProductAttributeSaveRequest {

    /**
     * 产品唯一业务ID
     */
    @NotBlank(message = "产品唯一业务ID不能为空")
    private String productBizId;

    /**
     * 产品绑定的分类表唯一业务ID列表（产品绑定多级分类）
     */
    @NotEmpty(message = "产品绑定的分类表唯一业务ID列表不能为空")
    private List<String> categoryBizIdList;

    /**
     * 产品绑定的属性列表集合（含录入值）
     */
    @NotEmpty(message = "产品绑定的属性列表集合（含录入值）不能为空")
    private List<ApiRelObjectFieldDto> apiRelObjectFieldDtoList;
}
