package com.yd.product.feign.enums;

/**
 * 产品服务公共枚举
 */
public enum ProductCommonEnum {

    //产品上架状态枚举
    PRODUCT_LAUNCH_STATUS_DSH("待审核","DSH"),
    PRODUCT_LAUNCH_STATUS_CG("审核成功","CG"),
    PRODUCT_LAUNCH_STATUS_SB("审核失败","SB"),
    PRODUCT_LAUNCH_STATUS_ZS("在售","ZS"),
    PRODUCT_LAUNCH_STATUS_TS("停售","TS"),
    PRODUCT_LAUNCH_STATUS_XJ("下架","XJ"),
    PRODUCT_LAUNCH_STATUS_YS("预售","YS"),
    PRODUCT_LAUNCH_STATUS_DKS("待开售","DKS"),

    //审核操作状态
    APPROVAL_STATUS_TG("通过","TG"),
    APPROVAL_STATUS_WTG("未通过","WTG"),
    ;


    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    ProductCommonEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }
    public String getItemLabel() {
        return itemLabel;
    }
    public String getItemValue() {
        return itemValue;
    }
}
