package com.yd.product.feign.client.productattribute;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.productattribute.ApiProductAttributeFeignFallbackFactory;
import com.yd.product.feign.request.product.ApiProductAddRequest;
import com.yd.product.feign.request.productattribute.ApiProductAttributeSaveRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 产品服务-产品属性信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiProductAttributeFeignFallbackFactory.class)
public interface ApiProductAttributeFeignClient {

    /**
     * 保存-产品属性信息
     * @param request
     * @return
     */
    @PostMapping("/save")
    Result save(@Validated @RequestBody ApiProductAttributeSaveRequest request);


}
