package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchPageRequest;
import com.yd.product.feign.response.productlaunch.ApiProductLaunchPageResponse;
import com.yd.product.service.model.ProductLaunch;
import com.yd.product.service.dao.ProductLaunchMapper;
import com.yd.product.service.service.IProductLaunchService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 产品上架信息表（新表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class ProductLaunchServiceImpl extends ServiceImpl<ProductLaunchMapper, ProductLaunch> implements IProductLaunchService {

    @Override
    public IPage<ApiProductLaunchPageResponse> page(Page<ApiProductLaunchPageResponse> page,
                                                    ApiProductLaunchPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public ProductLaunch queryOne(String productLaunchBizId) {
        return this.getOne(new LambdaQueryWrapper<ProductLaunch>().eq(ProductLaunch::getProductLaunchBizId,productLaunchBizId));
    }
}
