package com.yd.product.feign.fallback.announcementcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.client.announcementcommissionratio.ApiAnnouncementCommissionRatioFeignClient;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioBatchSaveRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioEditRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioPageRequest;
import com.yd.product.feign.request.announcementcommissionratio.ApiAnnouncementCommissionRatioAddRequest;
import com.yd.product.feign.response.announcementcommissionratio.ApiAnnouncementCommissionRatioDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 产品服务-公告佣比率规格明细信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAnnouncementCommissionRatioFeignFallbackFactory implements FallbackFactory<ApiAnnouncementCommissionRatioFeignClient> {
    @Override
    public ApiAnnouncementCommissionRatioFeignClient create(Throwable cause) {
        return new ApiAnnouncementCommissionRatioFeignClient() {
            @Override
            public Result page(ApiAnnouncementCommissionRatioPageRequest request) {
                return null;
            }

            @Override
            public Result batchSave(ApiAnnouncementCommissionRatioBatchSaveRequest request) {
                return null;
            }

            @Override
            public Result add(ApiAnnouncementCommissionRatioAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiAnnouncementCommissionRatioEditRequest request) {
                return null;
            }

            @Override
            public Result editStatus(String announcementCommissionRatioBizId,Integer status) {
                return null;
            }

            @Override
            public Result<ApiAnnouncementCommissionRatioDetailResponse> detail(String announcementCommissionRatioBizId) {
                return null;
            }

            @Override
            public Result del(String announcementCommissionRatioBizId) {
                return null;
            }

            @Override
            public Result copy(String announcementCommissionRatioBizId) {
                return null;
            }
        };
    }
}
