package com.yd.product.api.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ProductCommonUtils {

    /**
     * 解析年限字符串为整数
     * @param yearStr
     * @return
     */
    public static Integer parseYearToInt(String yearStr) {
        if (yearStr == null || yearStr.trim().isEmpty()) {
            return null;
        }

        try {
            // 提取数字部分，支持"1"、"1年"、"第1年"等格式
            String numericPart = yearStr.replaceAll("[^0-9]", "").trim();
            if (numericPart.isEmpty()) {
                return null;
            }
            return Integer.parseInt(numericPart);
        } catch (NumberFormatException e) {
            return null;
        }
    }

    /**
     * 检查年限区间是否重叠
     * @param start1
     * @param end1
     * @param start2
     * @param end2
     * @return
     */
    public static boolean isYearRangeOverlap(int start1, int end1, int start2, int end2) {
        // 两个区间重叠的条件：区间1的结束年份 >= 区间2的开始年份
        return Math.max(start1, start2) <= Math.min(end1, end2);
    }

    /**
     * 将scope字符串解析为集合
     * @param scope
     * @return
     */
    public static Set<String> parseScopeToSet(String scope) {
        if (scope == null || scope.trim().isEmpty()) {
            return new HashSet<>();
        }

        return Arrays.stream(scope.split(";"))
                .map(String::trim)
                .filter(s -> !s.isEmpty())
                .collect(Collectors.toSet());
    }

    /**
     * 检查两个scope集合是否有交集
     */
    public static boolean hasScopeIntersection(Set<String> scopeSet1, Set<String> scopeSet2) {
        // 特殊情况处理
        if (scopeSet1.isEmpty() || scopeSet2.isEmpty()) {
            return false;
        }

        // 如果任一集合包含"全部"，则视为有交集
        if (scopeSet1.contains("全部") || scopeSet2.contains("全部")) {
            return true;
        }

        // 检查是否有共同元素
        for (String item : scopeSet1) {
            if (scopeSet2.contains(item)) {
                return true;
            }
        }

        return false;
    }

}
