package com.yd.product.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiExpectedSpeciesService;
import com.yd.product.feign.client.expectedspecies.ApiExpectedSpeciesFeignClient;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesImportRequest;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesPageRequest;
import com.yd.product.feign.response.expectedspecies.ApiExpectedSpeciesPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 来佣比率规格信息
 *
 * @author zxm
 * @since 2025-12-01
 */
@RestController
@RequestMapping("/expectedSpecies")
@Validated
public class ApiExpectedSpeciesController implements ApiExpectedSpeciesFeignClient {

    @Autowired
    private ApiExpectedSpeciesService apiExpectedSpeciesService;

    /**
     * 分页列表查询-来佣比率规格信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedSpeciesPageResponse>> page(ApiExpectedSpeciesPageRequest request) {
        return apiExpectedSpeciesService.page(request);
    }

    /**
     * 导入规格数据
     * @param request
     * @return
     */
    @Override
    public Result importSpecies(ApiExpectedSpeciesImportRequest request) {
        return apiExpectedSpeciesService.importSpecies(request);
    }

    /**
     * 删除规格数据 TODO
     * @param expectedSpeciesBizId
     * @return
     */
    @Override
    public Result delSpecies(String expectedSpeciesBizId) {
        return apiExpectedSpeciesService.delSpecies(expectedSpeciesBizId);
    }
}
