package com.yd.product.feign.fallback.product;

import com.yd.common.result.Result;
import com.yd.product.feign.client.product.ApiProductFeignClient;
import com.yd.product.feign.request.product.ApiProductAddRequest;
import com.yd.product.feign.request.product.ApiProductEditRequest;
import com.yd.product.feign.request.product.ApiProductPageRequest;
import com.yd.product.feign.response.product.ApiProductDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 产品服务-产品基础信息Feign降级处理
 */
@Slf4j
@Component
public class ApiProductFeignFallbackFactory implements FallbackFactory<ApiProductFeignClient> {
    @Override
    public ApiProductFeignClient create(Throwable cause) {
        return new ApiProductFeignClient() {
            @Override
            public Result page(ApiProductPageRequest request) {
                return null;
            }

//            @Override
//            public Result edit(ApiProductEditRequest request) {
//                return null;
//            }
//
//            @Override
//            public Result<ApiProductDetailResponse> detail(String productBizId) {
//                return null;
//            }
//
//            @Override
//            public Result del(String productBizId) {
//                return null;
//            }
        };
    }
}
