package com.yd.product.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.feign.client.relobjectcategory.ApiRelObjectCategoryFeignClient;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiAttributeSettingService;
import com.yd.product.api.service.ApiRelProjectProductLaunchService;
import com.yd.product.api.service.ApiSpeciesPriceService;
import com.yd.product.api.service.ApiSpeciesSettingService;
import com.yd.product.feign.dto.ApiSpeciesPriceDto;
import com.yd.product.feign.dto.ApiSpeciesTypeDto;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchParameterPageRequest;
import com.yd.product.feign.request.relprojectproductlaunch.ApiRelProjectProductLaunchPageRequest;
import com.yd.product.feign.response.productlaunch.ApiAttributeSettingDto;
import com.yd.product.feign.response.relprojectproductlaunch.ApiProductLaunchParameterPageResponse;
import com.yd.product.feign.response.relprojectproductlaunch.ApiRelProjectProductLaunchPageResponse;
import com.yd.product.service.service.IRelProjectProductLaunchService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelProjectProductLaunchServiceImpl implements ApiRelProjectProductLaunchService {

    @Autowired
    private IRelProjectProductLaunchService iRelProjectProductLaunchService;

    @Autowired
    private ApiAttributeSettingService apiAttributeSettingService;

    @Autowired
    private ApiSpeciesSettingService apiSpeciesSettingService;

    @Autowired
    private ApiSpeciesPriceService apiSpeciesPriceService;

    @Autowired
    private ApiRelObjectCategoryFeignClient apiRelObjectCategoryFeignClient;

    /**
     * 分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectProductLaunchPageResponse>> page(ApiRelProjectProductLaunchPageRequest request) {
        Page<ApiRelProjectProductLaunchPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelProjectProductLaunchPageResponse> iPage = iRelProjectProductLaunchService.page(page, request);
        if (!CollectionUtils.isEmpty(iPage.getRecords())) {
            List<ApiRelProjectProductLaunchPageResponse> responses = iPage.getRecords();
            for (ApiRelProjectProductLaunchPageResponse response : responses) {
                //设置的产品上架信息的参数列表
                List<ApiAttributeSettingDto> apiAttributeSettingDtoList = apiAttributeSettingService.queryAttributeSettingDtoList(response.getProductLaunchBizId());
                response.setApiAttributeSettingDtoList(apiAttributeSettingDtoList);

                //规格信息配置列表
                // 规格信息配置列表 - 按规格类型分组
                List<ApiSpeciesTypeDto> apiSpeciesTypeDtoList = apiSpeciesSettingService.querySpeciesTypeDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesTypeDtoList(apiSpeciesTypeDtoList);

                //规格价格配置列表
                List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList = apiSpeciesPriceService.querySpeciesPriceDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesPriceDtoList(apiSpeciesPriceDtoList);
            }
            iPage.setRecords(responses);
        }
        return Result.success(iPage);
    }

    /**
     * 产品参数字段-分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiProductLaunchParameterPageResponse>> parameterPage(ApiProductLaunchParameterPageRequest request) {
        Page<ApiProductLaunchParameterPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiProductLaunchParameterPageResponse> iPage = iRelProjectProductLaunchService.parameterPage(page, request);
        if (!CollectionUtils.isEmpty(iPage.getRecords())) {
            List<ApiProductLaunchParameterPageResponse> responses = iPage.getRecords();
            List<String> productLaunchBizIdList = responses.stream()
                    .map(ApiProductLaunchParameterPageResponse::getProductLaunchBizId)
                    .collect(Collectors.toList());
            //查询-对象分类关系列表
            ApiRelObjectCategoryQueryRequest queryRequest = new ApiRelObjectCategoryQueryRequest();
            queryRequest.setObjectBizIdList(productLaunchBizIdList);
            Result<List<ApiRelObjectCategoryQueryResponse>> result = apiRelObjectCategoryFeignClient.query(queryRequest);
            List<ApiRelObjectCategoryQueryResponse> categoryQueryResponses = result.getData();

            for (ApiProductLaunchParameterPageResponse response : responses) {
                //设置的产品上架信息的参数列表
                List<ApiAttributeSettingDto> apiAttributeSettingDtoList = apiAttributeSettingService.queryAttributeSettingDtoList(response.getProductLaunchBizId());
                response.setApiAttributeSettingDtoList(apiAttributeSettingDtoList);

                //规格信息配置列表
                // 规格信息配置列表 - 按规格类型分组
                List<ApiSpeciesTypeDto> apiSpeciesTypeDtoList = apiSpeciesSettingService.querySpeciesTypeDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesTypeDtoList(apiSpeciesTypeDtoList);

                //规格价格配置列表
                List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList = apiSpeciesPriceService.querySpeciesPriceDtoList(response.getProductLaunchBizId());
                response.setApiSpeciesPriceDtoList(apiSpeciesPriceDtoList);

                //设置分类列表（产品险种列表）
                if (!CollectionUtils.isEmpty(categoryQueryResponses)) {
                    List<ApiRelObjectCategoryQueryResponse> categoryQueryResponseList = categoryQueryResponses
                            .stream()
                            .filter(dto -> dto.getObjectBizId().equals(response.getProductLaunchBizId()))
                            .collect(Collectors.toList());
                    response.setCategoryQueryResponseList(categoryQueryResponseList);
                }
            }
            iPage.setRecords(responses);
        }
        return Result.success(iPage);
    }
}
