package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 产品上架信息表（新表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("product_launch")
public class ProductLaunch implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 关联产品表唯一业务ID（上架的产品）
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 标题
     */
    @TableField("title")
    private String title;

    /**
     * 短标题
     */
    @TableField("short_title")
    private String shortTitle;

    /**
     * 主图url（多个url用分号分隔）
     */
    @TableField("main_urls")
    private String mainUrls;

    /**
     * 详情图（多个url用分号分隔）
     */
    @TableField("detail_urls")
    private String detailUrls;

    /**
     * 详情描述
     */
    @TableField("detail_description")
    private String detailDescription;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @TableField("scope")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 状态：0-待审核 1-审核成功 2-审核失败 3-在售 4-停售 5-下架 6-预售
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
