package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 产品基础表
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("product")
public class Product implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 产品唯一业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 产品名称
     */
    @TableField("product_name")
    private String productName;

    /**
     * 产品代码
     */
    @TableField("product_code")
    private String productCode;

    /**
     * 状态：0=下架，1=在售 2=预售 3=停售
     */
    @TableField("status")
    private Integer status;

    /**
     * 支持货币
     */
    @TableField("currency")
    private String currency;

    /**
     * 销售方式
     */
    @TableField("sales_method")
    private String salesMethod;

    /**
     * 开售时间
     */
    @TableField("sale_start_time")
    private LocalDateTime saleStartTime;

    /**
     * 停售时间
     */
    @TableField("discontinuation_time")
    private LocalDateTime discontinuationTime;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @TableField("scope")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 产品图片
     */
    @TableField("picture")
    private String picture;

    /**
     * 产品所属公司的所在地
     */
    @TableField("location")
    private String location;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
