package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预计来佣比率表（新表）
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Getter
@Setter
@TableName("expected_commission_ratio")
public class ExpectedCommissionRatio implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预计来佣比率表唯一业务ID
     */
    @TableField("expected_commission_ratio_biz_id")
    private String expectedCommissionRatioBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    @TableField("product_launch_biz_id")
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID
     */
    @TableField("product_biz_id")
    private String productBizId;

    /**
     * 规格表唯一业务ID（冗余）
     */
    @TableField("species_biz_id")
    private String speciesBizId;

    /**
     * 保障年限
     */
    @TableField("warranty_period")
    private String warrantyPeriod;

    /**
     * 缴费年限（起）
     */
    @TableField("start_period")
    private String startPeriod;

    /**
     * 缴费年限（止）
     */
    @TableField("end_period")
    private String endPeriod;

    /**
     * 标保折算比例
     */
    @TableField("discount_ratio")
    private BigDecimal discountRatio;

    /**
     * 计算基数（保费/保费*折算比例）
     */
    @TableField("cardinal_number")
    private BigDecimal cardinalNumber;

    /**W
     * 来佣类型
     */
    @TableField("commission_type")
    private String commissionType;

    /**
     * 来佣比例
     */
    @TableField("commission_ratio")
    private BigDecimal commissionRatio;

    /**
     * 出单渠道
     */
    @TableField("channel")
    private String channel;

    /**
     * 有效开始时间
     */
    @TableField("effective_start")
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    @TableField("effective_end")
    private LocalDateTime effectiveEnd;

    /**
     * 来佣日规则
     */
    @TableField("rules")
    private String rules;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
