package com.yd.product.feign.dto;

import lombok.Data;
import java.math.BigDecimal;

@Data
public class ApiSpeciesPriceDto {

    /**
     * 规格价格维护表唯一业务ID
     */
    private String speciesPriceBizId;

    /**
     * 产品上架信息表唯一业务ID（冗余）
     */
    private String productLaunchBizId;

    /**
     * 上架产品规格配置表信息JSON串
     */
    private String speciesJson;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 库存
     */
    private BigDecimal inventory;

    /**
     * 配图url
     */
    private String illustrationUrl;

    /**
     * 状态：0=下架，1=上架
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

}
