package com.yd.product.feign.request.product;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiProductEditRequest {

    /**
     * 产品唯一业务ID
     */
    @NotBlank(message = "产品唯一业务ID不能为空")
    private String productBizId;

    /**
     * 产品名称
     */
    @NotBlank(message = "产品名称不能为空")
    private String productName;

    /**
     * 支持货币
     */
    private String currency;

    /**
     * 销售方式
     */
    private String salesMethod;

    /**
     * 开售时间
     */
    private LocalDateTime saleStartTime;

    /**
     * 停售时间
     */
    private LocalDateTime discontinuationTime;

    /**
     * 产品图片
     */
    private String picture;

    /**
     * 通用备注
     */
    private String remark;
}
