package com.yd.product.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.product.feign.request.product.ApiProductPageRequest;
import com.yd.product.feign.response.product.ApiProductPageResponse;
import com.yd.product.service.dto.ProductDto;
import com.yd.product.service.model.Product;
import com.yd.product.service.dao.ProductMapper;
import com.yd.product.service.service.IProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 产品基础表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class ProductServiceImpl extends ServiceImpl<ProductMapper, Product> implements IProductService {

    @Override
    public IPage<ApiProductPageResponse> page(Page<ApiProductPageResponse> page,
                                              ApiProductPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<Product> queryList(ProductDto dto) {
        List<Product> list = baseMapper.selectList(new LambdaQueryWrapper<Product>()
                .eq(StringUtils.isNotBlank(dto.getProductBizId()) && !dto.getIsExcludeMy(),Product::getProductBizId,dto.getProductBizId())
                .eq(StringUtils.isNotBlank(dto.getProductName()),Product::getProductName,dto.getProductName())
                .ne(dto.getIsExcludeMy(),Product::getProductBizId,dto.getProductBizId())
        );
        return list;
    }

    @Override
    public Product queryOne(String productBizId) {
        return this.getOne(new LambdaQueryWrapper<Product>().eq(Product::getProductBizId,productBizId));
    }
}
