package com.yd.product.feign.client.expectedcommissionratio;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.expectedcommissionratio.ApiExpectedCommissionRatioFeignFallbackFactory;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioSaveRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 产品服务-预计来佣比率信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiExpectedCommissionRatioFeignFallbackFactory.class)
public interface ApiExpectedCommissionRatioFeignClient {

    /**
     * 分页列表查询-预计来佣比率信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiExpectedCommissionRatioPageRequest request);

    /**
     * 保存-预计来佣比率信息
     * @param request
     * @return
     */
    @PostMapping("/save")
    Result save(@Validated @RequestBody ApiExpectedCommissionRatioSaveRequest request);
}
