package com.yd.product.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.product.api.service.ApiExpectedCommissionRatioService;
import com.yd.product.api.service.ApiProductLaunchService;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioPageRequest;
import com.yd.product.feign.request.expectedcommissionratio.ApiExpectedCommissionRatioSaveRequest;
import com.yd.product.feign.response.expectedcommissionratio.ApiExpectedCommissionRatioPageResponse;
import com.yd.product.service.model.ExpectedCommissionRatio;
import com.yd.product.service.model.ProductLaunch;
import com.yd.product.service.service.IExpectedCommissionRatioService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiExpectedCommissionRatioServiceImpl implements ApiExpectedCommissionRatioService {

    @Autowired
    private IExpectedCommissionRatioService iExpectedCommissionRatioService;

    @Autowired
    private ApiProductLaunchService apiProductLaunchService;

    /**
     * 分页列表查询-预计来佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiExpectedCommissionRatioPageResponse>> page(ApiExpectedCommissionRatioPageRequest request) {
        Page<ApiExpectedCommissionRatioPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiExpectedCommissionRatioPageResponse> iPage = iExpectedCommissionRatioService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 保存-预计来佣比率信息
     * @param request
     * @return
     */
    @Override
    public Result save(ApiExpectedCommissionRatioSaveRequest request) {
        //校验产品上架信息是否存在
        Result<ProductLaunch> result = apiProductLaunchService.checkProductLaunchIsExist(request.getProductLaunchBizId());
        ProductLaunch productLaunch = result.getData();
        //先删后新增
        //删除
        iExpectedCommissionRatioService.delByProductLaunchBizId(request.getProductLaunchBizId());

        //新增
        List<ExpectedCommissionRatio> expectedCommissionRatioList = request.getApiExpectedCommissionRatioDtoList()
                .stream().map(dto -> {
                    ExpectedCommissionRatio ratio = new ExpectedCommissionRatio();
                    BeanUtils.copyProperties(dto,ratio);
                    ratio.setSpeciesJson(!CollectionUtils.isEmpty(dto.getApiSpeciesSettingDtoList()) ? JSON.toJSONString(dto.getApiSpeciesSettingDtoList()) : "");
                    return ratio;
                }).collect(Collectors.toList());
        iExpectedCommissionRatioService.saveBatch(expectedCommissionRatioList);
        return Result.success();
    }
}
