package com.yd.product.feign.fallback.expectedspecies;

import com.yd.common.result.Result;
import com.yd.product.feign.client.expectedspecies.ApiExpectedSpeciesFeignClient;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesImportRequest;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesListRequest;
import com.yd.product.feign.request.expectedspecies.ApiExpectedSpeciesPageRequest;
import com.yd.product.feign.response.expectedspecies.ApiExpectedSpeciesListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 产品服务-来佣比率规格信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExpectedSpeciesFeignFallbackFactory implements FallbackFactory<ApiExpectedSpeciesFeignClient> {
    @Override
    public ApiExpectedSpeciesFeignClient create(Throwable cause) {
        return new ApiExpectedSpeciesFeignClient() {
            @Override
            public Result page(ApiExpectedSpeciesPageRequest request) {
                return null;
            }

            @Override
            public Result importSpecies(ApiExpectedSpeciesImportRequest request) {
                return null;
            }

            @Override
            public Result delSpecies(String expectedSpeciesBizId) {
                return null;
            }

            @Override
            public Result<List<ApiExpectedSpeciesListResponse>> list(ApiExpectedSpeciesListRequest request) {
                return null;
            }
        };
    }
}
