package com.yd.product.feign.request.productlaunch;

import com.yd.product.feign.dto.ApiProductLaunchDto;
import com.yd.product.feign.dto.ApiSpeciesPriceDto;
import com.yd.product.feign.dto.ApiSpeciesSettingDto;
import com.yd.product.feign.response.productlaunch.ApiAttributeSettingDto;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class ApiProductLaunchSaveRequest {

    /**
     * 来源 1-复制 null-其他
     */
    private Integer source;

    /**
     * 产品上架主信息
     */
    private ApiProductLaunchDto apiProductLaunchDto;

    /**
     * 设置的产品参数列表
     */
    private List<ApiAttributeSettingDto> apiAttributeSettingDtoList;

    /**
     * 设置上架产品规格列表
     */
    private List<ApiSpeciesSettingDto> apiSpeciesSettingDtoList;

    /**
     * 规格价格配置列表
     */
    private List<ApiSpeciesPriceDto> apiSpeciesPriceDtoList;
}
