package com.yd.product.feign.client.relprojectproductlaunch;

import com.yd.common.result.Result;
import com.yd.product.feign.fallback.relprojectproductlaunch.ApiRelProjectProductLaunchFeignFallbackFactory;
import com.yd.product.feign.request.productlaunch.ApiProductLaunchParameterPageRequest;
import com.yd.product.feign.request.relprojectproductlaunch.ApiRelProjectProductLaunchPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 产品服务-项目产品上架关系信息Feign客户端
 */
@FeignClient(name = "yd-product-api", fallbackFactory = ApiRelProjectProductLaunchFeignFallbackFactory.class)
public interface ApiRelProjectProductLaunchFeignClient {

    /**
     * 分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRelProjectProductLaunchPageRequest request);

    /**
     * 产品参数字段-分页列表查询-租户项目产品上架关系信息
     * @param request
     * @return
     */
    @PostMapping("/parameter/page")
    Result parameterPage(@RequestBody ApiProductLaunchParameterPageRequest request);


}
