package com.yd.product.feign.response.expectedcommissionratio;

import com.yd.product.feign.dto.ApiSpeciesSettingDto;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiExpectedCommissionRatioDetailResponse {

    /**
     * 预计来佣比率表主键ID
     */
    private Long id;

    /**
     * 预计来佣比率表唯一业务ID
     */
    private String expectedCommissionRatioBizId;

    /**
     * 产品上架信息表唯一业务ID
     */
    private String productLaunchBizId;

    /**
     * 产品唯一业务ID
     */
    private String productBizId;

    /**
     * 规格条件列表JSON串
     */
    private String speciesJson;

    /**
     * 上架产品规格配置表信息JSON串对应转化的列表
     */
    private List<ApiSpeciesSettingDto> apiSpeciesSettingDtoList;

    /**
     * 保障年限（固定规格条件）
     */
    private String warrantyPeriod;

    /**
     * 期数（固定规格条件）
     */
    private String issueNumber;

//    /**
//     * 缴费年限（起）
//     */
//    @TableField("start_period")
//    private String startPeriod;
//
//    /**
//     * 缴费年限（止）
//     */
//    @TableField("end_period")
//    private String endPeriod;

    /**
     * 标保折算比例
     */
    private BigDecimal discountRatio;

    /**
     * 计算基数（保费/保费*折算比例）
     */
    private BigDecimal cardinalNumber;

    /**
     * 来佣类型
     */
    private String commissionType;

    /**
     * 来佣比例
     */
    private BigDecimal commissionRatio;

    /**
     * 出单渠道
     */
    private String channel;

    /**
     * 有效开始时间
     */
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    private LocalDateTime effectiveEnd;

    /**
     * 来佣日规则
     */
    private String rules;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
