package com.yd.product.feign.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiProductLaunchDto {

    /**
     * 产品上架信息表唯一业务ID
     */
    @NotBlank(message = "产品上架信息表唯一业务ID不能为空")
    private String productLaunchBizId;

    /**
     * 关联产品表唯一业务ID（上架的产品）
     */
    @NotBlank(message = "关联产品表唯一业务ID不能为空")
    private String productBizId;

    /**
     * 标题
     */
    private String title;

    /**
     * 短标题
     */
    private String shortTitle;

    /**
     * 主图url列表
     */
    private List<String> mainUrlsList;

    /**
     * 详情图列表
     */
    private List<String> detailUrlsList;

    /**
     * 详情描述
     */
    private String detailDescription;

    /**
     * 状态：0-待审核 1-审核成功 2-审核失败 3-在售 4-停售 5-下架 6-预售
     */
    private String status;

    /**
     * 是否定时开售 0-否 1-是
     */
    private String isTiming;

    /**
     * 开售日期
     */
    private LocalDateTime releaseDate;

    /**
     * 是否隐藏价格（是否定时开售为是的时候才设置这个） 0-否 1-是
     */
    private String isHiddenPrice;

    /**
     * 是否限购 0-否 1-是
     */
    private String isPurchaseLimit;

    /**
     * 限购日期单位 DAILY-每日 WEEKLY-每周 MONTHLY-每月 YEARLY-每年
     */
    private String limitDateUnit;

    /**
     * 限购数量
     */
    private Integer limitQuantity;

    /**
     * 上架到对应的项目列表
     */
    private List<String> projectBizIdList;
}
