package com.yd.product.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 公告佣比率规格明细表
 * </p>
 *
 * @author zxm
 * @since 2025-12-01
 */
@Getter
@Setter
@TableName("announcement_commission_ratio")
public class AnnouncementCommissionRatio implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 公告佣比率规格明细表唯一业务ID
     */
    @TableField("announcement_commission_ratio_biz_id")
    private String announcementCommissionRatioBizId;

    /**
     * 公告佣比率规格表唯一业务ID
     */
    @TableField("announcement_species_biz_id")
    private String announcementSpeciesBizId;

    /**
     * 费用名称（转介费等）
     */
    @TableField("expense_name")
    private String expenseName;

    /**
     * 佣金年限（起）
     */
    @TableField("start_period")
    private String startPeriod;

    /**
     * 佣金年限（止）
     */
    @TableField("end_period")
    private String endPeriod;

    /**
     * 标保折算比例（基本保费）
     */
    @TableField("discount_ratio")
    private BigDecimal discountRatio;

    /**
     * 计算基数（保费/保费*折算比例）
     */
    @TableField("cardinal_number")
    private BigDecimal cardinalNumber;

    /**
     * 佣金率
     */
    @TableField("commission_rate")
    private BigDecimal commissionRate;

    /**
     * 有效开始时间
     */
    @TableField("effective_start")
    private LocalDateTime effectiveStart;

    /**
     * 有效结束时间
     */
    @TableField("effective_end")
    private LocalDateTime effectiveEnd;

    /**
     * 适用范围（经纪人/分销员/加盟商/签单员/转介人/全部，字典）
     */
    @TableField("scope")
    private String scope;

    /**
     * 是否受汇率影响 0-否 1-是，字典）
     */
    @TableField("is_exchange_rate")
    private String isExchangeRate;

    /**
     * 结算币种（字典）
     */
    @TableField("currency")
    private String currency;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 创建人名称
     */
    @TableField("creator_name")
    private String creatorName;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 更新人名称
     */
    @TableField("updater_name")
    private String updaterName;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
